﻿function getExternalMenues() {
    var selected = $('#treeOrg').treeview('getChecked');
    var orgid;
    var uoid;
    var prfid;
    selected.forEach(function (node) {
        if (node.orgid !== undefined && node.uoid !== undefined) {
            getExternalMenu(node.orgid, node.uoid, node.id);
        }
    });
}
function getExternalMenu(orgid, uoid, id) {
    var szParam = "'pOrgId' : '" + orgid + "', 'pUoId':'" + uoid + "', 'pProfId':'" + id + "'";
    $.ajax({
        url: URLExternalMenu,
        type: 'POST',
        data: '{' + szParam + '}',
        dataType: "json",
        cache: false,
        contentType: "application/json; charset=utf-8",
        async: true,
        success: function (resp) {
            if (resp.status === 200) {
                jsondata = resp.data;
                drawMenu(orgid, uoid, id, jsondata);
            }
            else if (resp.status === 302) {
                $.xhrPool.abortAll();
                window.location.href = resp.data;
            }
            else if (resp.status === 500) {
                alert(resp.data);
            }
        },
        error: function (xhr, ajaxOptions, thrownError) {
            Common.ShowError(xhr, ajaxOptions, thrownError);
        }
    });
};
function drawMenu(orgid, uoid, id, jsondata) {
    for (var i = 0; i < jsondata.ExternalLinks.length; i++) {
        var externallink = jsondata.ExternalLinks[i];

        menuItem.append('<li id="left-sidebar-menu-external' + externallink.Id + '"  class="treeview">' +
                   '<a href="javascript:void(0)" onclick="OpenExternalLink(this);" data-params="' + externallink.URLParam + '" data-url="' +  URLExternalInbox + '">' +
                           '<i class="fa fa-external-link" style="display: table-cell;"></i> <span style="display: table-cell; white-space: normal; -ms-word-break: normal;">' + externallink.Description + '</span>' +
                    '</a>' +
                '</li>');
    }

    if (jsondata != null && jsondata.ExternalLinks != null && jsondata.ExternalLinks.length > 0 && typeof MenuExternalSelected === 'function') {
        var lis = $("ul.sidebar-menu").find($("li"));
        for (var i = 0; i < lis.length; i++) {
            lis[i].className = "treeview";
        }
        MenuExternalSelected()
    }
}
function OpenExternalLink(src) {
    url = $(src).data("url");
    params = $(src).data("params");
    CallAction(url, params);
}
